<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2023 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement Balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichier COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/utils");

/**
 * Chargement du formulaire
 *
 * @param string $sujet	-	Sujet de la lettre
 * @param string $type	-	Type de la lettre (= nom de la page SPIP qui affichera le contenu)
 * @param string $ref	-	Référence de la lettre (= paramètre 'ref' de la page de type)
 *
 * Exemple : $sujet = "Ma lettre" ; $type = "newsletter" ; ref= "18256F"
 * génèrera une URL : spip.php?page=newsletter&ref=18256F pour la consultation
 * de la lettre et l'expédiera sous le titre "Ma Lettre" aux destinataires
 *
 */
 
function formulaires_abonner_lettre_charger_dist()
{
	return array();
}

	
function formulaires_abonner_lettre_verifier_dist()
{
	$erreurs = array();
	
	// Controle de l'email
	$e=_request('email');
	if(!email_valide($e)) {
		$erreurs['email'] = _T('sibmail:email_invalide');
	} 
	
	// Contrôle des listes
	$target = _request('to');
	$dest = array();
	if(!is_array($target)) {
		$erreurs['to'] = _T('sibmail:aucune_liste_selectionnee');
	} else {
		foreach($target as $one) {
			$v = intval($one);
			if($v) $dest[] = $v;
		}
	}
	
	// Controle anti-robots
	$pasvu = isset($_REQUEST['avatar'])?$_REQUEST['avatar']:'';
	if(strlen($pasvu)) {
		$erreurs['message_erreur'] = _T('sibmail:piratage');
	}	
	
	// Controle captcha
	$secu = isset($_REQUEST['msgsecu'])?strtolower($_REQUEST['msgsecu']):'';
	if($secu != $_SESSION['securecode']) {
		$erreurs['msgsecu'] = _T('sibmail:code_securite_invalide');
	} 	
	
	// En cas de problème, on sort
	if(count($erreurs)) return $erreurs;
	
	// Sinon on prépare la suite
	$_POST['nom'] = textebrut(_request('nom'));
	$_POST['prenom'] = textebrut(_request('prenom'));
	$_POST['to'] = $dest;
	// S'agit-il d'un auteur ?
	$_POST['id_auteur'] = isset($_SESSION['id_auteur']) ? $_SESSION['id_auteur'] : 0;
	
	spip_log("SIBMAIL::Demande d'inscription de $e : ".serialize($dest),"sibmail."._LOG_INFO_IMPORTANTE);
	return $erreurs;
}


function formulaires_abonner_lettre_traiter_dist() {	
	
	$ida = intval($_POST['id_auteur']);
	if($ida > 0) {
		// C'est un auteur et non un visiteur anonyme
		// On utilise la fonction simple de souscription
		$options = array(
			'nom' => $_POST['nom'],
			'prenom' => $_POST['prenom'],
			'listes' => $_POST['to']
			);
		sibmail_subscribe($ida,$options);
		/*
		$user = getContactData($_POST['email']);
		sibmail_transmitContactData($user);
		*/
		return;
	}
	
	// Ce n'est pas un auteur : on procède au double opt-in

	/* Recherche de l'attribut Brevo dans lequel stocker le pseudo de l'auteur */
	$pseudo = strtoupper(lire_config('sibmail/attribut_pseudo'));
	
	/* Préparation de la requête - Inscription en double opt-in */	
	$data = new stdClass();
	$data->email = $_POST['email'];
	$attribs = new stdClass();
	$attribs->NOM = strtoupper($_POST['nom']);
	$attribs->PRENOM = $_POST['prenom'];
	// $attribs->$pseudo = $_POST['prenom'] . " " . strtoupper($_POST['nom']);
	$data->attributes = $attribs;
	$data->includeListIds = $_POST['to'];
	$data->templateId = intval(lire_config('sibmail/template_doi'));
	$data->redirectionUrl = lire_config('sibmail/url_doi');
	
	// Envoi de la requete
	$request = array(
		'cmd' => 'POST',
		'api' => "contacts/doubleOptinConfirmation",
		'data' => json_encode($data)
		);
	
	spip_log("SIBMAIL::Envoi inscription : ".serialize($data),"sibmail."._LOG_INFO_IMPORTANTE);
	$response = json_decode(sibmail_sendRequest($request));
	spip_log("SIBMAIL::Retour inscription : ".serialize($response),"sibmail."._LOG_INFO_IMPORTANTE);
	if(isset($response->code)) {
		return array('message_erreur' => $response->message);
	} else {
		return array('message_ok' => _T('sibmail:confirmer_inscription'));
	}
}

	
			