<?php

if (!defined('_ECRIRE_INC_VERSION')) return;
include_spip('sibmail_fonctions');
include_spip('config/sibmail');
 
 
/**
 * Propager les adhérents notifiés par helloAsso vers Brevo
 *
 * @param int $t
 * @return int
 */
function genie_propager_adherents_dist($t) {
	spip_log("SIBMAIL::Propagation des adhérents","sibmail."._LOG_INFO_IMPORTANTE);
	sibmail_propager_n_adherents();
	return 1;
}

/**
 * Détecter les fichiers de notification HelloAsso
 */
function isHelloOrder($filename) {
	return preg_match('/^Order_[0-9_]+\.json$/',$filename);
}

/**
 * Iterer sur les fichiers HelloAsso
 */
function sibmail_propager_n_adherents() {
	
	// La fonction est-elle configurée ?
	if((!is_readable(_SIBM_HELLOASSO_CONFIG)) or (!is_dir(_SIBM_COLLECT))) return;     
	// spip_log("SIBMAIL::HelloAsso : Lecture de la configuration","sibmail."._LOG_INFO_IMPORTANTE);
	
	$jtxt = file_get_contents(_SIBM_HELLOASSO_CONFIG);
	$cfg = json_decode($jtxt, true); // Lecture en tableau associatif
	// spip_log("SIBMAIL::HelloAsso Config : ".serialize($cfg),"sibmail."._LOG_INFO_IMPORTANTE);
	
	// On parcourt les fichiers à traiter
	$dirfiles = scandir(_SIBM_COLLECT);
	$files = array_filter($dirfiles,"isHelloOrder");
	// $n = count($files);
	// spip_log("SIBMAIL::HelloAsso : ".serialize($dirfiles)." $n fichiers a traiter","sibmail."._LOG_INFO_IMPORTANTE);
	$i=0;
	foreach($files as $file) {
		if($i < _SIBM_VOLUME_ADHESION) {
			spip_log("SIBMAIL::HelloAsso : traitement de $file","sibmail."._LOG_INFO_IMPORTANTE);
			hello_traiter_un_ordre(_SIBM_COLLECT,$cfg,$file);
			$i++;
		}
	}
}

function hello_traiter_un_ordre($where,$conf,$file) {
	$txt=file_get_contents("$where/$file");	
	$helloData = json_decode($txt,false);
	
	if( is_object($helloData) 
		and isset($helloData->eventType)  // exists and not NULL
		and ($helloData->eventType == "Order")) {
			$order = analyseHelloOrder($helloData->data);
			notifyOrder($order,$conf);
			rename("$where/$file","$where/done_$file");
		} else {
			rename("$where/$file","$where/failed_$file");
		}
}

function analyseHelloOrder($theData) {
	$order = new stdClass();
	
	$order->type = $theData->formType;
	$order->slug = $theData->formSlug;
	$order->date = $theData->date;
	$order->payer = $theData->payer;
	
	foreach($theData->items as $item) {
		switch($item->type) {
		case "Membership":
			$adh = new stdClass();
			$adh->type = $item->name;
			$adh->lastName = $item->user->lastName;
			$adh->firstName = $item->user->firstName;
			$adh->email = findAdhEmail($item->customFields);
			$adh->amount = $item->amount;
			$adh->id = $item->id;
			$adh->cardUrl = $item->membershipCardUrl;
			$order->membership = $adh;
			break;
		case "Donation":
			$order->donation = $item->amount;
			break;
		default:
			break;
		}
	}
	return($order);		
}


function findAdhEmail($fields) {
	$emails = array();
	foreach($fields as $field) {
		if(strpos($field->name, "mail") and ($field->type == "TextInput")) {
			array_push($emails, $field->answer);
		}
	}
	return $emails;			
}

function notifyOrder($order,$conf) {
	$listes = array();  // Listes auxquelles souscrire
	$flists = array();	// Listes associées au formulaire d'adhésion
	
	if(isset($conf['slug2list']) and isset($conf['slug2list'][$order->slug])) {
		$flists = $conf['slug2list'][$order->slug];
		// spip_log("SIBMAIL::HelloAsso listes : ".serialize($flists),"sibmail."._LOG_INFO_IMPORTANTE);
	}
			
	if(isset($order->membership)) {
		// Adhésion - On enregistre les données de l'adhérent dans une structure pour Brevo
		$data = new stdClass();
		$data->email = $order->membership->email[0];
		
		$attribs = new stdClass();
		$attribs->NOM = $order->membership->lastName;
		$attribs->PRENOM = $order->membership->firstName;
		$data->attributes = $attribs;
		
		if(isset($flists['membership']))
			array_push($listes, $flists['membership']);
		if( isset($flists['donation']) and isset($order->donation))
			array_push($listes, $flists['donation']);
		$data->listIds = $listes;
		
		$data->updateEnabled = true;
		
		// On prépare la requête et on l'envoie
		$request['data'] = json_encode($data);
		$request['cmd'] = 'POST';
		$request['api'] = "contacts";
		$answer = sibmail_sendRequest($request,true);
		spip_log("SIBMAIL::HelloAsso ".serialize($request). " retourne ".$answer->code,"sibmail."._LOG_INFO_IMPORTANTE);
	}		
			
}

?>
