<?php

/*******************************************************************************\
 * SIBACTU, plugin et squelette pour SPIP - https://www.spip.net/              *
 *         dédié à la gestion de mails via Sendinblue (Brevo)                  *
 *                                                                             *
 *         Copyright (C) 2023-2025 Renaud LAURETTE                             *
 *                                                                             *
\*******************************************************************************/

include_spip("inc/utils");


function formulaires_composer_actualites_charger_dist($confirmation)
{

	$valeurs = array(
		'sujet' => lire_config('sibactu/sujet'),
		'tedito' =>  lire_config('sibactu/tedito'),
		);
	
	$items = items_actualite();
	foreach($items as $key => $desc) {
		$valeurs["t$key"] = lire_config("sibactu/t$key");
	}
	return $valeurs;
}

/**
 * Vérification du contenu de la lettre
 *
 */
	
function formulaires_composer_actualites_verifier_dist($confirmation)
{
	$items = items_actualite();
	
	// listes admissibles d'objets dans une lettre d'actualité
	$alistes = array_keys($items);

	// listes de titres obligatoires dans une lettre d'actualité
	// 1 - Champs minimum
	$t1 = array(
		'sujet',		// Sujet
		'template', 	// Modèle de courier (squelette) 
		'tedito', 		// Editorial 
		);
	// 2 - Pour chaque champ admissible supplémentaire, le titre est obligatoire
	// Le nom du champ titre est le nom du champ admissible, précédé de 't'
	$t2 = array_map(fn(string $key): string => "t$key",$alistes);
	$tlistes = array_merge($t1,$t2);
	
	// autres champs admissibles
	$facultatifs = array(
		'imgedito',
		'edito'
		);
	
	$count = 0; $titres = 0;
	
	// Analyse de la requête pour retrouver les champs de la lettre
	foreach($_REQUEST as $key => $value) {
		
		// décomposition des champs contenant des listes
		if(in_array($key,$alistes)) {
			$v = array();
			$tok = strtok($value," \t,");
			while($tok !== false) {
				$v[] = intval($tok);
				$count++;
				$tok = strtok(" \t,");
			}
			$valeurs[$key] = $v;
		} 
		
		// normalisatikon des titres
		if(in_array($key,$tlistes)) {
			$valeurs[$key] = $value;
			if(strlen(trim($value))) $titres++;
		}
		
		// traitement des champs facultatifs
		if(in_array($key,$facultatifs)) {
			$valeurs[$key] = trim($value);
			if(strlen(trim($value)) > 10) $count++;
		}
	}
	
	//	Contrôle : au moins un champ admissible est requis 
	//	Les champs obligatoires sont vérifiés par le plugin SAISIES
	if($count == 0) {
		return array('message_erreur' => _T('sibactu:err_contenu_vide'));
	} else {
		$data = serialize($valeurs);
		$_REQUEST['_actudata'] = $data;
		$_REQUEST['_template'] = $valeurs['template'];
		return array();
	}
}

/**
 * Enregistrement du conteu de la lettre
 *
 * les actus sérialisées sont stockées dans un fichier.
 * Tant qu'elles ne sont pas validées, elles restent dans un répertoire temporaire
 * Quand elles deviendront validées, elles seront déplacées dans le répertoire IMG
 *
 * Le programme qui compose la lettre doit être en mesure de trouver les données dans
 * le répertoire IMG, et sinon de les chercher dans le répertoire temporaire
 */
 
function formulaires_composer_actualites_traiter_dist($confirmation) {
	
	// On vérifie l'existance des répertoires
	$repertoire = _DIR_TMP . 'actualites/';
	$repertoire2 = _DIR_IMG . 'actualites/';
	if(!is_dir($repertoire)) mkdir($repertoire);
	if(!is_dir($repertoire2)) mkdir($repertoire2);
	
	// et on prépare le fichier temporaire
	$fichier = md5('actu'.time());
	$file = $repertoire . $fichier;
	file_put_contents($file,$_REQUEST['_actudata']);
	
	// On prépare la page qui préparera l'envoi
	$params = array(		
		'sujet' => _request('sujet'),
		'type' => $_REQUEST['_template'],	// Nom de la page qui définit la composition HTML de la page
		'id' => $fichier,					// Identifiant des données à composer
		);
	$redirect = generer_url_public($confirmation,$params,true, false);
	
	// On retourne le résultat
	$msg = _T('sibactu:ok_composition');
	return array( 
		'message_ok' => $msg,		// En principe inutile à cause du redirect
		'redirect' => $redirect
		);
}

	
			