<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2025 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : http://apcveb.free.fr/                                    *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichiers COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/


if (!defined('_ECRIRE_INC_VERSION')) return;
include_spip('sibmail_fonctions');
include_spip("inc/utils");

function genie_propager_agenda_dist($t) {
	$avance = intval(lire_config('sibactu/avance_agenda'));			// Nbre de jours d'anticipation
	$status = sibactu_notifier_agenda($avance+1);					// Prévenir $avance jours avant
	//$status = sibactu_notifier_agenda(2);							// et de nouveau la veille
	return (1);
}

function sibactu_notifier_agenda($avance) {

	// Lecture de la configuration	
	$sujet = lire_config('sibactu/sujet_agenda');					// Titre et sujet de la lettre
	$tlistes = explode(',', lire_config('sibactu/listes_agenda')); 	// Listes de diffusion
	$template = lire_config('sibactu/modele_agenda');				// Modèle de la lettre
	$metagenda = "evt_agenda_$avance";								// Nom de la meta à sauvegarder
	$silence = intval(lire_config('sibactu/silence_agenda'));		// Répis entre deux annonces
	
	// Conversion en entiers
	$listes = array();
	foreach($tlistes as $t) { 
		$listes[] = intval($t); 
	}
	
	// Recherche des événements pertinents
	$today = date("Y-m-d H:i:s");
	$next = date("Y-m-d H:i:s",mktime(0, 0, 0, date("m")  , date("d")+$avance, date("Y")));
	$where = array ( //where
					"date_debut > ".sql_quote($today),
					"date_debut <= ".sql_quote($next),
					"statut= 'publie'"
					);
	$evts = sql_select(
				array("id_evenement","id_article","date_debut","date_fin","titre"),
				'spip_evenements', // from
				$where
				);
	
	// Récupérer les événements précédemment notifiés
	$evt_anciens = array();
	if(isset($GLOBALS['meta'][$metagenda])) {
		$evt_anciens = unserialize($GLOBALS['meta'][$metagenda]);
	}

	// filtrer pour ne pas notifier en boucle
	$evt_nouveaux = $id_nouveaux = $id_candidats = array();
	foreach($evts as $e) {
		$id_candidats[] = $e['id_evenement'];
		if(!in_array($e['id_evenement'],$evt_anciens)) {
			$evt_nouveaux[] = $e;
			$id_nouveaux[] = $e['id_evenement'];
		}
	}
	spip_log("SIBACTU::NotifierAgenda($avance) - Evenements candidats : ".serialize($id_candidats),"sibmail."._LOG_INFO_IMPORTANTE);	
	// Les candidats seront les anciens au prochain appel
	ecrire_meta($metagenda,serialize($id_candidats));
	
	if(count($id_nouveaux)) {
		// Nouveaux événements à diffuser	
		spip_log("SIBACTU::NotifierAgenda($avance) - Evenements retenus de base : ". serialize($id_nouveaux),"sibmail."._LOG_INFO_IMPORTANTE);

		// On étend la période de recherche pour éviter les envois successifs
		$nextPlus = date("Y-m-d H:i:s",mktime(0, 0, 0, date("m")  , date("d")+$avance+$silence, date("Y")));
		$wherePlus = array ( //where
					"date_debut > ".sql_quote($next),
					"date_debut <= ".sql_quote($nextPlus),
					"statut= 'publie'"
					);
		$evtPlus = sql_select(
					array("id_evenement","id_article","date_debut","date_fin","titre"),
					'spip_evenements', // from
					$wherePlus
					);			
		
		// On filtre de nouveau
		foreach($evtPlus as $e) {
			$id_candidats[] = $e['id_evenement'];
			if(!in_array($e['id_evenement'],$evt_anciens)) {
				$evt_nouveaux[] = $e;
				$id_nouveaux[] = $e['id_evenement'];
			}
		}
		
		// On met à jour les candidats
		ecrire_meta($metagenda,serialize($id_candidats));
		spip_log("SIBACTU::NotifierAgenda($avance) - Evenements retenus au final : ". serialize($id_nouveaux),"sibmail."._LOG_INFO_IMPORTANTE);
		
		// Génération et enregistrerment des données pour la lettre
		$actudata = array(
			'evt' => $id_nouveaux,
			'template' => $template,
			'sujet' => $sujet
			);
		$repertoire = _DIR_IMG . 'actualites/';
		if(!is_dir($repertoire)) mkdir($repertoire);
		$fichier = "agenda_$avance".'_'.time();
		$file = $repertoire . $fichier;
		file_put_contents($file,serialize($actudata));
	
		// Génération de l'URL de la page
		$url = generer_url_public($template, array('id' => $fichier), true, false);
		//$sujet = filtrer_entites($sujet);
	
		// Envoi (emmeteur par défaut : le webmestre du site)
		$cid = sibmail_createCampaign($sujet, 0, $listes, $sujet, $url);
		if($cid) {
			if(sibmail_activateCampaign($cid)) {
				spip_log("SIBACTU::NotifierAgenda($avance) - $fichier envoyé à : ". serialize($listes),"sibmail."._LOG_INFO_IMPORTANTE);
			} else {
				spip_log("SIBACTU::NotifierAgenda($avance) - $fichier ECHEC activation pour : ". serialize($listes),"sibmail."._LOG_INFO_IMPORTANTE);
				// Comme l'envoi a échoué, on restore les anciens précédents
				// pour laisser une nouvelle chance ...
				ecrire_meta($metagenda,serialize($evt_anciens));
			}
		}
	} else {
		spip_log("SIBACTU::NotifierAgenda($avance) - aucun événement à notifier","sibmail."._LOG_INFO_IMPORTANTE);
	}
	return (1);
}
