<?php

/*******************************************************************************\
 * SIBACTU, plugin et squelette pour SPIP - https://www.spip.net/              *
 *         dédié à la gestion de mails via Sendinblue (Brevo)                  *
 *                                                                             *
 *         Copyright (C) 2023 Renaud LAURETTE                                  *
 *                                                                             *
\*******************************************************************************/
include_spip("inc/utils");

/**
 * Définition dynamique des objets pouvant figurer dans une lettre d'actualité
 *
 * @pipeline sibactu_items_actualite
 * @return array	Tableau décrivant chaque item
 */
function items_actualite() {
	static $items = [];
	
	if(!count($items)) {
		
		$items = array(
			'brv' => array( 
				'objet' => 'breve',
				'label_titre' => _T('sibactu:titrebrv'),
				'label_liste' => _T('sibactu:lstbrv'),
				),
			'art' => array( 
				'objet' => 'article',
				'label_titre' => _T('sibactu:titreart'),
				'label_liste' => _T('sibactu:lstart'),
				),	
			);

		// On donne la chance aux plugins d'insérer leurs propres objets
		$items = pipeline(
			'sibactu_items_actualite',
			array(
				'args' => [],
				'data' => $items
				)
			);
		
	}
	
	return $items;
}

/**
 * Filtre retournant l'élément de configuration demandé
 *
 * Syntaxe : [(#VAL{nom_element}|config_sibactu)]
 *
 * @param string $nom		Nom du paramètre à extraire
 * @return array			Tableau de valeurs trouvées ou tableau vide
 */
 
function config_sibactu($nom) {
		
	switch($nom) {
	case 'items':
		return items_actualite();
	case 'templates':
	default:
		return [];
	}
}


/**
 * Lecture d'un fichier d'actualités
 *
 * @param string src - nom du fichier à lire
 * @param array tableaux - liste des champs tableau à trouver
 * @param array textes - liste des champs texte à trouver
 * @return array - le tableau des champs lus
 *
 * Un champ texte est obligatoire : 'sujet'
 */

function actualites($src,$textes,$tableaux) {
	
	/* initialisation */	
	foreach($textes as $key)
		$data[$key] = '';
	foreach($tableaux as $key)
		$data[$key] = array();
		
	/* lecture du fichier d'actualités */
	$file = _DIR_IMG . 'actualites/' . $src;
	$file2 = _DIR_TMP . 'actualites/' . $src;
	$contents = FALSE;
	
	// On cherche d'abord les données validées dans IMG
	// Si on ne trouve pas, on cherche les données non validées dans le répertoire temporaire
	if(file_exists($file)) {		
		$contents = file_get_contents($file);
	} else {
		$contents = file_get_contents($file2);
	}
	if($contents === FALSE) {
		$data['sujet'] = _T('actu:pas_de_fichier');
		return $data;
	}
	
	/* décodage */
	$actu = @unserialize($contents);
	if(!is_array($actu)) {
		$data['sujet'] = _T('actu:pb_format_fichier');
		return $data;
	}
	
	/* remplissage */
	foreach($textes as $key) {
		if(array_key_exists($key,$actu)) {
			$data[$key] = $actu[$key];
		}
	}
	foreach($tableaux as $key) {
		if(array_key_exists($key,$actu)) {
			$data[$key] = is_array($actu[$key]) ? $actu[$key] : array($actu[$key]);
		}
	}		
	
	/* on envoie */
	return $data;
}

?>
