<?php

/*******************************************************************************\
 * BIODIV, plugin et squelette pour SPIP - https://www.spip.net/               *
 *         dédié à la gestion d'observations naturalistes                      *
 *                                                                             *
 *         Copyright (C) 2008-2025 Renaud LAURETTE                             *
 *                                                                             *
 * BIODIV a été développé initialement pour le projet Biodiv.Balma de l'APCVEB *
 * (Association de Protection du Cadre de Vie et de l'Environnement Balmanais) * 
 *     voir Biodiv.Balma : https://balma.biodiv.fr/                            *
 *     voir APCVEB : https://apcveb.fr/                                        *
 *                                                                             *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.         *
 *  Pour plus de détails voir les fichiers COPYING.txt et LICENCE-BIODIV.md     *
\*******************************************************************************/

include_spip("inc/utils");

/**
 * Chargement du formulaire
 *
 * @param string $sujet	-	Sujet de la lettre
 * @param string $type	-	Type de la lettre (= nom de la page SPIP qui affichera le contenu)
 * @param string $ref	-	Référence de la lettre (= paramètre 'ref' de la page de type)
 * @param string $contacts	Nom de la page fournissant le détail des membres d'une liste
 * @param string $statut	Nom de la page fournissant le statut de la campagne
 *
 * Exemple : $sujet = "Ma lettre" ; $type = "newsletter" ; ref= "18256F"
 * génèrera une URL : spip.php?page=newsletter&ref=18256F pour la consultation
 * de la lettre et l'expédiera sous le titre "Ma Lettre" aux destinataires
 *
 */
 
function formulaires_envoyer_lettre_charger_dist($sujet,$type,$ref,$contacts,$statut)
{
	$valeurs = array(
		'sujet' => $sujet,
		'type' => $type,
		'id' => $ref,
		'contacts' => $contacts
		);
	return $valeurs;
}

	
function formulaires_envoyer_lettre_verifier_dist($sujet,$type,$ref,$contacts,$statut)
{
	$sender = intval(_request('from'));
	$target = _request('to'); 				
	/* On vérifie que $target est un tableau d'entiers et on filtre au besoin */
	$dest = array();
	if(is_array($target)) {
		foreach($target as $one) {
			$v = intval($one);
			if($v) $dest[] = $v;
		}
	}
	
	if(($sender>0) and (count($dest) >0)) {	// Sélection ok 		
		$_POST['_sender'] = $sender;
		$_POST['_target'] = $dest;
	    spip_log("SIBMAIL::Campagne de $sender pour ".serialize($dest),"sibmail."._LOG_INFO_IMPORTANTE);
		return array();
	} else {  // problème 		
		return array(
			'message_erreur' => _T('sibmail:err_pb_from_ou_to',array('from'=>$sender,'to'=>serialize($target)))
			);
	}
}


function formulaires_envoyer_lettre_traiter_dist($sujet,$type,$ref,$contacts,$statut) {		
	/* pipeline */
	list($sujet,$type,$ref) = pipeline('avant_envoyer_lettre',array($sujet,$type,$ref));	
	
	/* créer la campagne de mailing */	
	$url = generer_url_public($type,array('id' => $ref),true, false);
	$sujet = filtrer_entites($sujet);
	spip_log("SIBMAIL::Lettre de campagne = $url","sibmail."._LOG_INFO_IMPORTANTE);
	spip_log("SIBMAIL::Sujet de campagne = $sujet","sibmail."._LOG_INFO_IMPORTANTE);
	$cid = sibmail_createCampaign($sujet,_request('_sender'),_request('_target'),$sujet,$url);	
	
	/* contrôler */
	if($cid) {
		if(sibmail_activateCampaign($cid)) {
			return array('message_ok' => _T('sibmail:campagne_creee', array('num'=>$cid, 'statut'=>$statut)));	
		} else {
			return array( 'message_erreur' => _T('sibmail:echec_activation_campagne', array('num'=>$cid)));
		}
	} else {
		return array( 'message_erreur' => _T('sibmail:echec_creation_campagne'));	
	}
}

	
			