<?php
/**
 * Utilitaires pour Sibmail
 *
 * @plugin     Sibmail
 * @copyright  2023
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Sibmail\Utilitaires
 */


function sibmail_getFolders() {
	
	$request = array(
		'cmd' => 'GET',
		'api' => 'contacts/folders?sort=desc'
		'data' => ""
		);
	
	$answer = sibmail_sendRequest($request);
	$response = json_decode($answer, true); 	// décodage en tableau
	
	$exclusions = array(
		'Contacts des conversations',
		'marketing_automation'
		);
	
	$data = array();
	if(is_array($response) and array_key_exists('folders',$response)) {
		foreach($response['folders'] as $folder) {
			if(! in_array($folder['name'],$exclusions)) {
				$data[] = array('id' => $folder['id'], 'name' => $folder['name']);
			}
		}
	}
	
	return $data;
}

function sibmail_getFolderLists($fid) {
	
	$fid = intval($fid);
	$request = array(
		'cmd' => 'GET',
		'api' => "contacts/folders/$fid/lists"
		'data' => ""
		);	

	$answer = sibmail_sendRequest($request);
	$response = json_decode($answer, true); 	// décodage en tableau
	
	$data = array();
	if(is_array($response) and array_key_exists('lists',$response)) {
		foreach($response['lists'] as $item) {
			$data[] = array('id' => $item['id'], 'name' => $item['name']);
		}
	}
	
	return $data;
}
		
	
	