<?php
/**
 * Définit les autorisations du plugin Sibmail
 *
 * @plugin     Sibmail
 * @copyright  2023
 * @author     Renaud LAURETTE
 * @licence    GNU/GPL
 * @package    SPIP\Sibmail\Autorisations
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}

/**
 * Fonction d'appel pour le pipeline
 * @pipeline autoriser 
 */
function sibmail_autoriser() {
}


/* Exemple
function autoriser_sibmail_configurer_dist($faire, $type, $id, $qui, $opt) {
	// type est un objet (la plupart du temps) ou une chose.
	// autoriser('configurer', '_biodiv') => $type = 'biodiv'
	// au choix :
	return autoriser('webmestre', $type, $id, $qui, $opt); // seulement les webmestres
	return autoriser('configurer', '', $id, $qui, $opt); // seulement les administrateurs complets
	return $qui['statut'] == '0minirezo'; // seulement les administrateurs (même les restreints)
	// ...
}
*/


/**
 * Autorisation d'envoyer une lettre sibmail (campagne Brevo)
 * s'appelle avec #AUTORISER{envoyer,_mailing,...} ou autoriser('envoyer','_mailing',...)
 * Attention: underscore obligatoire car 'mailing' n'est pas un objet de la base
 *
 * @param  string $faire Action demandée
 * @param  string $type  Type d'objet sur lequel appliquer l'action
 * @param  int    $id    Identifiant de l'objet
 * @param  array  $qui   Description de l'auteur demandant l'autorisation
 * @param  array  $opt   Options de cette autorisation
 * @return bool          true s'il a le droit, false sinon
**/
function autoriser_mailing_envoyer_dist($faire, $type, $id, $qui, $opt) {
	// Autorisé par défaut aux administrateurs
	return autoriser('configurer');
}

/**
 * Autorisation de consulter les statistiques et données Brevo
 * s'appelle avec #AUTORISER{envoyer,_mailing,...} ou autoriser('envoyer','_mailing',...)
 * Attention: underscore obligatoire car 'mailing' n'est pas un objet de la base
 *
 * @param  string $faire Action demandée
 * @param  string $type  Type d'objet sur lequel appliquer l'action
 * @param  int    $id    Identifiant de l'objet
 * @param  array  $qui   Description de l'auteur demandant l'autorisation
 * @param  array  $opt   Options de cette autorisation
 * @return bool          true s'il a le droit, false sinon
**/
function autoriser_mailing_consulter_dist($faire, $type, $id, $qui, $opt) {
	// Autorisé par défaut aux administrateurs
	return autoriser('configurer');
}
